
// create a space ship on screen that flies left and right
// and also fires lasers

// declare a type to store data for our lasers
type laserType
	sprite as integer
	speed as float
	state as integer
endtype

// declare a type to store data for our ship
type shipType
	sprite as integer
	speed as integer
	direction as integer
	fireTimer as float
	lasers as laserType [ 10 ]
endtype

// variable for our ship, make it global so it can be
// easily accessed by all parts of the program
global spaceShip as shipType

// set a virtual resolution of 1024 x 768
SetVirtualResolution ( 1024, 768 )

// call functions to set up the ship and its lasers
SetupShip ( )
SetupLasers ( )

// our main loop
do
	// call functions to update the ship and its lasers
	UpdateShip ( )
	UpdateLasers ( )
	
	// update the screen
	sync ( )
loop

function SetupLasers ( )
	
	// this function will set up the lasers
	
	// load an image for the laser
	image = LoadImage ( "laser.png" )
	
	// create sprites for each laser
	for i = 1 to spaceShip.lasers.length
		spaceShip.lasers [ i ].sprite = CreateSprite ( image )
		ResetLaser ( i, 0 )
	next i
	
endfunction

function ResetLaser ( index as integer, visible as integer )
	
	// this function will reset the lasers, giving them default values
	
	// state, speed, position to match the ship and visibility
	spaceShip.lasers [ index ].state = 0
	spaceShip.lasers [ index ].speed = Random ( 80, 100 ) / 10.0
	SetSpritePosition ( spaceShip.lasers [ index ].sprite, GetSpriteX ( spaceShip.sprite ) + GetSpriteWidth ( spaceShip.sprite ) / 2 - 8 , GetSpriteY ( spaceShip.sprite ) - 12 )
	SetSpriteVisible ( spaceShip.lasers [ index ].sprite, visible )
	
endfunction

function UpdateLasers ( )
	
	// this function updates the lasers
	
	// increment the timer to control when the lasers should fire
	spaceShip.fireTimer = spaceShip.fireTimer + 0.01
	
	// run through all the lasers
	for i = 1 to spaceShip.lasers.length
		
		// if the state is 0 then this laser is available
		if spaceShip.lasers [ i ].state = 0
			
			// only fire the laser if the fire timer is over 0.25
			if spaceShip.fireTimer >= 0.25
				
				// reset the laser, set the state to 1 and reset the timer
				ResetLaser ( i, 1 )
				spaceShip.lasers [ i ].state = 1
				spaceShip.fireTimer = 0.0
				
			endif
			
		endif
		
		// when the state is 1 the laser has been fired
		if spaceShip.lasers [ i ].state = 1
			
			// move the laser up the screen
			SetSpritePosition ( spaceShip.lasers [ i ].sprite, GetSpriteX ( spaceShip.lasers [ i ].sprite ), GetSpriteY ( spaceShip.lasers [ i ].sprite ) - spaceShip.lasers [ i ].speed )
			
			// check for the laser leaving the screen
			if GetSpriteY ( spaceShip.lasers [ i ].sprite ) < 0
				
				// reset the laser and allow it to be used again
				ResetLaser ( i, 0 )
				
			endif
		endif
	next i
	
endfunction

function SetupShip ( )
	
	// set up for our ship
	
	// create a sprite, control how fast it moves and set its initial direction
	spaceShip.sprite = CreateSprite ( LoadImage ( "TopFighter1.png" ) )
	spaceShip.speed = 2
	spaceShip.direction = 0

	// position the sprite towards the centre and near the bottom of the screen
	SetSpritePosition ( spaceShip.sprite, 1024 / 2, 626 )
	
endfunction

function UpdateShip ( )
	
	// control the movement of the ship
	
	// get the X coordinate of the ship
	x = GetSpriteX ( spaceShip.sprite )
		
	// find out whether it has moved to the left or right side
	if ( spaceShip.direction = 0 and x > 976 ) or ( spaceShip.direction = 1 and x < 0 )
		
		// reverse the speed and direction
		spaceShip.speed = -spaceShip.speed
		spaceShip.direction = not spaceShip.direction
		
	endif

	// add the current speed to the X position
	x = x + spaceShip.speed
	
	// update the position of our ship
	SetSpritePosition ( spaceShip.sprite, x, GetSpriteY ( spaceShip.sprite ) )
	
endfunction
